Congratulations = copy_table(BaseView)
Congratulations.definition = "congratulations"


function Congratulations:init(options)
    BaseView.init(self, def)
    self.start_delay = 0.3
    self.max = options
    self.stats = {
        score = 0,
        time = 0,
        bonus = 0,
    }
    snd_play_sound("congratulations_start")
end


function Congratulations:update(dt)
    BaseView.update(self, dt)
    
    if self.start_delay then
        self.start_delay = self.start_delay - dt
        if self.start_delay <= 0 then
            self.start_delay = nil
            self.shortcuts.time_label.enabled = true
            self.shortcuts.time.enabled = true
            snd_play_sound("congratulations_line")
        end
    end
    
    if not self.shortcuts.bonus_label.enabled and self.shortcuts.time_label.animator:is_finished() then
        self.shortcuts.bonus_label.enabled = true
        self.shortcuts.bonus.enabled = true
        snd_play_sound("congratulations_line")
    end

    if not self.shortcuts.score_label.enabled and self.shortcuts.bonus_label.animator:is_finished() then
        self.shortcuts.score_label.enabled = true
        self.shortcuts.score.enabled = true
        snd_play_sound("congratulations_line")
    end

    if self.shortcuts.time.enabled then
        self.stats.time = math.min(self.stats.time + self.max.time * dt / 1.7, self.max.time)
        
        local seconds = math.floor(self.stats.time) % 60
        local minutes = math.floor(self.stats.time / 60)
        self.shortcuts.time:set_text(string.format("%d:%02d", minutes, seconds))
    end

    if self.shortcuts.bonus.enabled then
        self.stats.bonus = math.min(self.stats.bonus + self.max.bonus * dt / 1.7, self.max.bonus)
        self.shortcuts.bonus:set_text(math.floor(self.stats.bonus))
    end

    if self.shortcuts.score.enabled then
        self.stats.score = math.min(self.stats.score + self.max.score * dt / 1.7, self.max.score)
        self.shortcuts.score:set_text(math.floor(self.stats.score))
    end

end


function Congratulations:continue_button(obj)
    fw:change_view(SaveScore, self.max)
end
